if(tutorial_setting == nil) then
  tutorial_setting = true
end

state:on_save(function(save)
  save:set("tutorial_setting", tutorial_setting)
end)
local set_hint_text = make_dynamic_hint(Hint.tutorial)
local portal_in = resize.location.portal_in
local portal_out = resize.location.portal_out
function is_orientation_ok(o)
  return o == R1 or o == F3
end
state:on_interface_render_lower(function(c)
  if(not tutorial_setting or not state:is_at_start()) then
    set_hint_text(nil);
    return
  end
  local function highlight(v)
    if(state.grid:at(v) == nil) then
      c:draw_rectangle(c.viewport:world_to_view(Rectangle.new(v, v)), {0, 1.0, 0, (2 + math.sin(2 * c.time))*0.1});
    end
  end;
  local p_in = state.grid:at(portal_in);
  local p_out = state.grid:at(portal_out);
  if p_in == nil and p_out == nil then
    local partial = state:get_partial_interaction();
    if partial.type == "PartialCreatePortal" then
      if partial.output == nil then
        if partial.input_orientation ~= R3 and partial.input_orientation ~= F3 then
          set_hint_text("Use the E/R keys or mouse wheel to rotate the input portal so that its colored side (the input) faces leftwards")
        else
          set_hint_text("Place the portal at the designated location")
          highlight(portal_in)
        end
      else
        if partial.input_orientation ~= R3 and partial.input_orientation ~= F3 then
          set_hint_text("You've opted to place your input portal in an orientation that may not allow blocks to enter it. Right click to cancel this choice.")
        elseif partial.input ~= portal_in then
          set_hint_text("You've opted to place your input portal at somewhere other than the suggested location. Right click to cancel this choice.")
        else
          if partial.output_orientation ~= R3 and partial.output_orientation ~= F3 then
            set_hint_text("Use the E/R keys or mouse wheel to rotate the output portal so that its colored side (the output) faces rightwards")
          else
            set_hint_text("Place the portal at the designated location")
            highlight(portal_out)
          end
        end
      end
    else
      set_hint_text("In this level, the input and the output are separated by an immovable wall. This is okay because you have the ability to create portals connecting distant points together.\n\nSelect the portal placement tool from the menu.")
    end
  else
    if p_out and p_in and p_in.what.type == "PortalIn" and p_out.what.type == "PortalOut" then
      if is_orientation_ok(p_in.view.object_to_view) and is_orientation_ok(p_out.view.object_to_view) then
        set_hint_text("You have successfully linked the two chambers with a portal! Press the play button to test the setup.")
      else
        set_hint_text("Your portals are not oriented correctly. Right click on these objects or use the delete tool (X) to delete these and try again.")
      end
    else
      set_hint_text("You have placed something improperly in the suggested input or output points (highlighted). Right click on these objects or use the delete tool (X) to delete these and try again.")
    end
  end
end)
